<?php
require_once __DIR__ . "/config.php";

$email    = clean($_GET['email'] ?? '');
$vertical = trim($_GET['v'] ?? '');
$campaign = trim($_GET['camp'] ?? '');
$id       = trim($_GET['id'] ?? '');

if (!$email){
    header("Content-Type: image/png");
    echo base64_decode("iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR4nGMAAQAABQABDQottAAAAABJRU5ErkJggg==");
    exit;
}

$country = detect_country_from_ip();
if ($country === '') $country = 'XX';

$base = __DIR__ . "/countries/$country/";

$global_folder = $base . "_global/";
ensure_dir($global_folder);
$global_opens = $global_folder . "opens.csv";

$vertical_folder = null;
$vertical_opens  = null;
if ($vertical !== ''){
    $vertical_folder = $base . $vertical . "/";
    ensure_dir($vertical_folder);
    $vertical_opens = $vertical_folder . "opens.csv";
}

$now = date('Y-m-d H:i:s');
$row = [$email, $country, $vertical, $campaign, $id, 'open', '', '', $now];

log_append($global_opens, $row);
if ($vertical_opens){
    log_append($vertical_opens, $row);
}

header("Content-Type: image/png");
echo base64_decode("iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR4nGMAAQAABQABDQottAAAAABJRU5ErkJggg==");
exit;
?>