<?php
// config.php - shared helpers + IP geolocation

date_default_timezone_set('UTC');

function clean($x){
    return trim(strtolower($x));
}

function ensure_dir($path){
    if (!is_dir($path)){
        mkdir($path, 0777, true);
    }
}

function log_append($file, $row){
    $fp = fopen($file, 'a');
    if ($fp){
        fputcsv($fp, $row);
        fclose($fp);
    }
}

function remove_from_csv($file, $email){
    if (!file_exists($file)) return;

    $email_clean = clean($email);
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $new = [];

    foreach ($lines as $line){
        if ($line === '') continue;
        $cols = str_getcsv($line);
        if (!isset($cols[0])) continue;
        if (clean($cols[0]) !== $email_clean){
            $new[] = $line;
        }
    }

    file_put_contents($file, implode("\n", $new) . (count($new) ? "\n" : ""));
}

function detect_country_from_ip(){
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
    $ip = explode(',', $ip)[0];
    $ip = trim($ip);

    if ($ip === '' || $ip === '127.0.0.1' || $ip === '::1'){
        return 'XX';
    }

    $url = "http://ip-api.com/json/" . urlencode($ip) . "?fields=countryCode,status";
    $ctx = stream_context_create(['http' => ['timeout' => 1]]);
    $json = @file_get_contents($url, false, $ctx);
    if ($json === false) return 'XX';
    $data = json_decode($json, true);
    if (!is_array($data) || ($data['status'] ?? '') !== 'success') return 'XX';
    return strtoupper($data['countryCode'] ?? 'XX');
}
?>