<?php
require_once __DIR__ . "/config.php";

$email    = clean($_GET['email'] ?? '');
$vertical = trim($_GET['v'] ?? '');
$campaign = trim($_GET['camp'] ?? '');
$id       = trim($_GET['id'] ?? '');
$offer    = $_GET['u'] ?? '';

if (!$email || !$offer){
    exit("Missing parameters.");
}

$country = detect_country_from_ip();
if ($country === '') $country = 'XX';

$base = __DIR__ . "/countries/$country/";

$global_folder = $base . "_global/";
ensure_dir($global_folder);
$global_open   = $global_folder . "opens.csv";
$global_clicks = $global_folder . "clicks.csv";

$vertical_folder = null;
$vertical_open   = null;
$vertical_clicks = null;
if ($vertical !== ''){
    $vertical_folder = $base . $vertical . "/";
    ensure_dir($vertical_folder);
    $vertical_open   = $vertical_folder . "opens.csv";
    $vertical_clicks = $vertical_folder . "clicks.csv";
}

remove_from_csv($global_open, $email);
if ($vertical_open){
    remove_from_csv($vertical_open, $email);
}

$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? '';
$uri    = $_SERVER['REQUEST_URI'] ?? '';
$tracking_url = $scheme . "://" . $host . $uri;

$now = date('Y-m-d H:i:s');
$row = [$email, $country, $vertical, $campaign, $id, 'click', $offer, $tracking_url, $now];

log_append($global_clicks, $row);
if ($vertical_clicks){
    log_append($vertical_clicks, $row);
}

header("Location: " . $offer, true, 302);
exit;
?>